/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.RangedInteger;

public class KoboldCrossbowAttackGoal<T extends MonsterEntity & ICrossbowUser>
extends Goal {
    public static final RangedInteger COOLDOWN_RANGE = new RangedInteger(20, 40);
    private final T shooter;
    private CrossbowState state = CrossbowState.UNCHARGED;
    private final double speed;
    private final float followDistanceSq;
    private int seeingTargetTicker;
    private int chargedTicksLeft;
    private int cooldown;

    public KoboldCrossbowAttackGoal(T shooter, double speed, float followDistance) {
        this.shooter = shooter;
        this.speed = speed;
        this.followDistanceSq = followDistance * followDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        return this.hasValidTarget() && this.canEquipCrossbow();
    }

    private boolean canEquipCrossbow() {
        return this.shooter.func_233631_a_(Items.field_222114_py);
    }

    public boolean func_75253_b() {
        return this.hasValidTarget() && (this.func_75250_a() || !this.shooter.func_70661_as().func_75500_f()) && this.canEquipCrossbow();
    }

    private boolean hasValidTarget() {
        return this.shooter.func_70638_az() != null && this.shooter.func_70638_az().func_70089_S();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.shooter.func_213395_q(false);
        this.shooter.func_70624_b(null);
        this.seeingTargetTicker = 0;
        if (this.shooter.func_184587_cr()) {
            this.shooter.func_184602_cy();
            ((ICrossbowUser)this.shooter).func_213671_a(false);
            CrossbowItem.func_220011_a((ItemStack)this.shooter.func_184607_cu(), (boolean)false);
        }
    }

    public void func_75246_d() {
        LivingEntity livingentity = this.shooter.func_70638_az();
        if (livingentity != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.shooter.func_70635_at().func_75522_a((Entity)livingentity);
            boolean bl = flag1 = this.seeingTargetTicker > 0;
            if (flag != flag1) {
                this.seeingTargetTicker = 0;
            }
            this.seeingTargetTicker = flag ? ++this.seeingTargetTicker : --this.seeingTargetTicker;
            double d0 = this.shooter.func_70068_e((Entity)livingentity);
            boolean bl2 = flag2 = (d0 > (double)this.followDistanceSq || this.seeingTargetTicker < 5) && this.chargedTicksLeft == 0;
            if (flag2) {
                --this.cooldown;
                if (this.cooldown <= 0) {
                    this.shooter.func_70661_as().func_75497_a((Entity)livingentity, this.isUnchargedState() ? this.speed : this.speed * 0.5);
                    this.cooldown = COOLDOWN_RANGE.func_233018_a_(this.shooter.func_70681_au());
                }
            } else {
                this.cooldown = 0;
                this.shooter.func_70661_as().func_75499_g();
            }
            this.shooter.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            if (this.state == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.shooter.func_184598_c(ProjectileHelper.func_221274_a(this.shooter, (Item)Items.field_222114_py));
                    this.state = CrossbowState.CHARGING;
                    ((ICrossbowUser)this.shooter).func_213671_a(true);
                }
            } else if (this.state == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.shooter.func_184587_cr()) {
                    this.state = CrossbowState.UNCHARGED;
                }
                if ((i = this.shooter.func_184612_cw()) >= CrossbowItem.func_220026_e((ItemStack)(itemstack = this.shooter.func_184607_cu()))) {
                    this.shooter.func_184597_cx();
                    this.state = CrossbowState.CHARGED;
                    this.chargedTicksLeft = 20 + this.shooter.func_70681_au().nextInt(20);
                    ((ICrossbowUser)this.shooter).func_213671_a(false);
                }
            } else if (this.state == CrossbowState.CHARGED) {
                --this.chargedTicksLeft;
                if (this.chargedTicksLeft == 0) {
                    this.state = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.state == CrossbowState.READY_TO_ATTACK && flag) {
                ((IRangedAttackMob)this.shooter).func_82196_d(livingentity, 1.0f);
                ItemStack itemstack1 = this.shooter.func_184586_b(ProjectileHelper.func_221274_a(this.shooter, (Item)Items.field_222114_py));
                CrossbowItem.func_220011_a((ItemStack)itemstack1, (boolean)false);
                this.state = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean isUnchargedState() {
        return this.state == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

